/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

void mainImage( out vec4 o, in vec2 i ) {
  o.rg=sin(i.xy-i.yx*iGlobalTime*.3);
 }

// The original was jusy the remarkably small mainImage function, but this
// relied on gl_FragColor being initialised to (0,0,0,1) so it needs a bit
// of help here.

void main(void) {
  mainImage ( gl_FragColor, gl_FragCoord.xy );
  gl_FragColor.b=0.0;
  gl_FragColor.a=length(gl_FragColor.rgb);
}
